//=============================================================================

/*:
 * @plugindesc BGMのピッチをシームレスに変更するコマンドを追加します。
 * 
 * @author LefTonbo
 *
 * @help
 * つかいかた：「BGMPitch 90」
 *
 */

//=============================================================================

var Imported = Imported || {};
Imported.LP_ChangePitchSeemless = true;

var LeftPlugin = LeftPlugin || {};

//=============================================================================

(function() {

//=============================================================================
// Game_Interpreter
//=============================================================================

var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function(command, args) {
  _Game_Interpreter_pluginCommand.call(this, command, args);
  if (command === 'BGMPitch') {
    var pitch = Number(args[0]);
    if (AudioManager._currentBgm && pitch != AudioManager._currentBgm['pitch']) {
      var buffer = AudioManager._bgmBuffer;
      if (buffer && buffer._sourceNode) {
        var pos = buffer.seek();
        var loop = buffer._sourceNode.loop;
        buffer._pitch = pitch / 100;
        buffer.play(loop, pos);
        AudioManager._currentBgm['pitch'] = pitch;
      }
    }
  }
};

//=============================================================================

})();

// EOF